
markup.push({

	// MARK: toggle

	InputToggleBlock:
	{
		"+": "BlockTemplate",
		geNodeClass: "GESourceToggleNode",
		gxFaceModel: {
			nsClass: "H4InputSwitchBlockFace",
			gxFaceModelKeyPath: "faceModel",
		},
		maximumInputs: 2,	// only allow 2 inputs connections
		minimumInputs: 2,	// always show 2 inputs connections
		gxTitle: "Switch",
		gxPopoverTitle: "Input Switch",
		gxLibraryDisplayName: "Input Switch",
		gxVerticalTitle: true,
		gxPopoverInfo: "InputTogglePopover",
		gxLibraryDescription: "Toggle between two sources",
		gxLibraryIcon: "library.toggle",
		gxSocketView: "ToggleSocketView",
		gxChildViews:
		{
			switch:
			{
				"+": "SwitchView.vertical.large.blockFace.noOff.showLive",
				gxFrameRect: "37, 32, 27, 60",
				gxVertical: true,
				axTitle: "Input Selector Switch",
			}
		}
	},

		
	ToggleSocketView:
	{
		"+": "SocketView",
		gxIndicatorPainter:
		{
			"+": "LabelFore.boldWeight.centerxy.size10",
			"A": { gxDefaultString: "A" },
			gxDefaultString: "B",
			active : {
				gxFontSize: 11,
				gxFontColor: "BlackColor",
			},
			gxFontColor: "ForeColorTheme1",
		},
	},

	
	// MARK: popover

	InputTogglePopover:
	{
		"+": "PopoverTemplate",
		gxTitle: "Input Switch",
		gxCanDrawSubviewsIntoLayer: true,
		gxLayout:
		[
			"H:|-12-[self(300)]-12-|",	// sets popover width
			"V:|-12-[self]-12-|",
			"V:|-41-[group]-14-|"
		],
		gxChildViews:
		{
			title: "PopoverTitle",
			switch: "PopoverOnOffSwitch",
			group:
			{
				"+": "GroupView.noBottomStroke",
				gxLayout:
				[
					"H:|-0-[self]-0-|",
					"H:|-20-[labelA(50)]-12-[switch(27)]-18-[text]-10-|",
					"H:[labelB(52)]",
					"V:|-16-[labelA]-15-[labelB]&alignLeft",
					"V:|-12-[switch(60)]-0-|",
					"V:|-12-[text(56)]",
				],
				gxChildViews: {
					labelA: {
						"+": "LabelView.left.useMarkup.size14",
						gxValueKey: "switchValue",
						gxFormatter: {
							nsClass: "GXDictionaryFormatter",
							gxDictionary: {
								0: "<foreColor1.withLive>Input A",
								1: "<foreColor2.disabled>Input A",
							}
						},
					},
					labelB: {
						"+": "LabelView.left.useMarkup.size14",
						gxValueKey: "switchValue",
						gxFormatter: {
							nsClass: "GXDictionaryFormatter",
							gxDictionary: {
								0: "<foreColor2.disabled>Input B",
								1: "<foreColor1.withLive>Input B",
							}
						},
					},
					switch: {
						"+": "SwitchView.vertical.large.noOff.showLive",
						//gxValueKey: "node.inputSource",
						gxVertical: true,
						gxBaselineOffset: 9,
						axTitle: "Input Switch",
						axHelp: "Toggles between two input wires connected to this block. Only one input is used at a time."
					},
					text:
					{
						"+": "DescriptionLabelView.useMarkup.left.centery.size11.wrap",
						gxValueKey: "switchValue",
						gxFormatter: {
							nsClass: "GXDictionaryFormatter",
							gxDictionary: {
								0: "Audio from Input <foreColor1>A</foreColor1> will flow through, audio from <foreColor1>B</foreColor1> will not.",
								1: "Audio from Input <foreColor1>B</foreColor1> will flow through, audio from <foreColor1>A</foreColor1> will not.",
							}
						},
					}

				}
			}
		}
	},

		
})
